CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     pipelined.h
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C   grid_rank 	The dimensionality, or rank, of the task grid.  The problem
C   		is laid out on a M x N grid, so the rank is 2.
C
C   num_tasks	The number of tasks, or processes, allocated to this job.
C		Tasks are given a unique identifier in the range of 0 to
C		num_tasks-1.
C
C   my_task	The unique task identifier.  Each task (or process) within
C		the program is given a different value for this variable.
C
C   ierror	An error flag used by MPI calls.
C
C   dims	An array which describes the number of rows and columns
C		in the task grid.
C
C   my_comm	An MPI communicator.
C
C   n_task,	Variables which contain the identifier of the task in the task
C   s_task,	grid which is to the north, south, east, and west,
C   e_task,	respectively, of the current task.
C   w_task
C
C   nw_task,    Variables which contain the identifier of the task in the
C   se_task     northwest corner and southeast corner, respectively, of the
C               task grid.
C
C   rowwidth	The number of rows in the problem domain, excluding boundaries,
C		which are allocated to each task.  This stencil problem has a
C		border of constant elements all around the outer edge of the
C		array.  This border is excluded from rowwidth.  Each task also
C		retains a similar border of ghost cells around the border,
C		which is also excluded.  Note that due to rounding the southern
C		and eastern borders may have fewer elements than interior
C		tasks, so this number cannot be used as a loop limit over the
C		local array.
C
C   colwidth	The number of columns in the problem domain, excluding
C		boundaries, which are allocated to each task.  See
C		"rowwidth" above for more details.
C
C   row_st	The starting row location in the problem domain of the local
C		task's stencil allocation.  The northern and western
C		boundaries are given row and column zero, respectively,
C		with each task given a consecutive set of rows and
C		columns.  For example, if the task grid is 2 x 2 with
C		rowwidth and colwidth each being 10, then (row_st,col_st)
C		will be (1,1) for task (0,0), (11, 1) for task
C		(1,0), (11,11) for task (1,1), etc.  The example problem
C		domain is 22 x 22 including boundaries.  The values row_st,
C		row_end, col_st, and col_end do not include the boundaries.
C
C   row_end	The ending row location in the problem domain of the local
C		task's stencil allocation.  See "row_st" for more detail.
C
C   col_st	The starting column location in the problem domain of the local
C		task's stencil allocation.  See "row_st" for more detail.
C
C   col_end	The ending column location in the problem domain of the local
C		task's stencil allocation.  See "row_st" for more detail.
C
C   task_rows	The number of rows in the local task's memory allocated
C		to the stencil.  This value includes rows allocated to the
C		boundaries.  Thus the array on the local task will have
C		a declaration like stencil(0:task_rows-1, 0:task_cols-1), where
C		boundary values are stored in rows zero and task_rows-1, and
C		in columns zero and task_cols-1.
C
C   task_cols	The number of columns in the local task's memory allocated
C		to the stencil.  See "task_rows" for more detail.
C
C   row_type	An MPI defined message type used to simplify communication
C		of stencil rows between neighboring tasks.
C
C   col_type	An MPI defined message type used to simplify communication
C		of stencil columns between neighboring tasks.
C
C   coords	An array used to record the position of the task in each
C		dimension of the task grid.  For an M x N grid the
C		coordinates are in the range of 0:M-1 and 0:N-1.
C
C   n_err,	The greatest accumulated error, i.e., MAX(local_err, n_err),
C   w_err	as reported by the northern neighbor.  w_err is similar, but
C		for the western neighbor.
C
C   wrap	An array used to tell MPI that dimension wrapping is not used.
C
      INTEGER grid_rank
      PARAMETER (grid_rank=2)
      INTEGER num_tasks, my_task, ierror, dims(grid_rank), my_comm
      INTEGER n_task, s_task, w_task, e_task, rowwidth, colwidth
      INTEGER row_st, row_end, col_st, col_end, task_rows, task_cols
      INTEGER row_type, col_type, coords(grid_rank), nw_task, se_task
      LOGICAL wrap(grid_rank)
      REAL n_err, w_err
      COMMON /com/ num_tasks, my_task, ierror, dims, wrap, my_comm,
     1   n_task, s_task, w_task, e_task, rowwidth, colwidth,
     2   row_st, row_end, col_st, col_end, task_rows, task_cols,
     3   row_type, col_type, coords, n_err, w_err, nw_task, se_task
